#include "setupdlg.h"
#include "ui_setupdlg.h"
#include "mainwindow.h"

#include "filerecorddlg.h"
#include "sharerecorddlg.h"
#include "audioinputdlg.h"
#include "videoinputdlg.h"
#include "videoqualitydlg.h"
#include "filerecorddlg.h"
#include "sharerecorddlg.h"

setupdlg::setupdlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::setupdlg)
{
    ui->setupUi(this);

    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nCurChannel = 0;

    ui->radioButton_CH1->setChecked(true);

    ui->BmpPath->setText( SC540dlg->path + QString("/Snapshot_BMP.bmp"));

    ui->JpgPath->setText( SC540dlg->path + QString("/Snapshot_JPG.jpg"));

    ui->pushBTN_SnapshotBMP->setEnabled(false);

    ui->pushBTN_SnapshotJPG->setEnabled(false);

    ui->pushBTN_VideoQuality->setEnabled(false);

    m_nTimerId = startTimer(1000);
}

setupdlg::~setupdlg()
{
    delete ui;
}

void setupdlg::timerEvent( QTimerEvent *event )
{
    if( event->timerId() == m_nTimerId )
    {
        MainWindow* SC540dlg = (MainWindow*)parentWidget();

        ui->m_info_1->setText(SC540dlg->str_info[0]);

        ui->m_info_2->setText(SC540dlg->str_info[1]);

        ui->m_info_3->setText(SC540dlg->str_info[2]);

        ui->m_info_4->setText(SC540dlg->str_info[3]);
    }
}

void setupdlg::on_pushBTN_VideoInpur_clicked()
{
    emit SetUpDialogSignal_VideoInput();
}

void setupdlg::on_pushBTN_AudioInput_clicked()
{
    emit SetUpDialogSignal_AudioInput();
}

void setupdlg::on_pushBTN_FileRecord_clicked()
{
    emit SetUpDialogSignal_FileRecord();
}

void setupdlg::on_pushBTN_ShareRecord_clicked()
{
    emit SetUpDialogSignal_ShareRecord();
}

void setupdlg::on_pushBTN_VideoQuality_clicked()
{
    emit SetUpDialogSignal_VideoQuality();
}

void setupdlg::on_radioButton_CH1_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nCurChannel = 0;

    ui->radioButton_CH1->setChecked(true);
}

void setupdlg::on_radioButton_CH2_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nCurChannel = 1;

    ui->radioButton_CH2->setChecked(true);
}

void setupdlg::on_radioButton_CH3_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nCurChannel = 2;

    ui->radioButton_CH3->setChecked(true);
}

void setupdlg::on_radioButton_CH4_clicked()
{
    MainWindow* SC540dlg = (MainWindow*)parentWidget();

    SC540dlg->m_nCurChannel = 3;

    ui->radioButton_CH4->setChecked(true);
}


